## -*-Tcl-*-
 # ###################################################################
 #  HTML mode - tools for editing HTML documents
 # 
 #  FILE: "htmlFtp.tcl"
 #                                    created: 00-06-22 14.01.57 
 #                                last update: 01-11-03 22.33.06 
 #  Author: Johan Linde
 #  E-mail: <alpha_www_tools@go.to>
 #     www: <http://go.to/alpha_www_tools>
 #  
 # Version: 3.1.4
 # 
 # Copyright 1996-2001 by Johan Linde
 #  
 # This program is free software; you can redistribute it and/or modify
 # it under the terms of the GNU General Public License as published by
 # the Free Software Foundation; either version 2 of the License, or
 # (at your option) any later version.
 # 
 # This program is distributed in the hope that it will be useful,
 # but WITHOUT ANY WARRANTY; without even the implied warranty of
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 # GNU General Public License for more details.
 # 
 # You should have received a copy of the GNU General Public License
 # along with this program; if not, write to the Free Software
 # Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 # 
 # ###################################################################
 ##

#===============================================================================
# This file contains the procs for the FTP submenu.
#===============================================================================

#===============================================================================
#  FTP  #
#===============================================================================

array set html::NFpwList {
	" " %FA ! %FB \" %F8 # %F9 \$ %FE % %FF & %FC ' %FD ( %F2 ) %F3
	* %F0 + %F1 , %F6 - %F7 . %F4 / %F5 0 %EA 1 %EB 2 %E8 3 %E9
	4 %EE 5 %EF 6 %EC 7 %ED 8 %E2 9 %E3 : %E0 ; %E1 < %E6 = %E7
	> %E4 ? %E5 @ %9A A %9B B %98 C %99 D %9E E %9F F %9C G %9D
	H %92 I %93 J %90 K %91 L %96 M %97 N %94 O %95 P %8A Q %8B
	R %88 S %89 T %8E U %8F V %8C W %8D X %82 Y %83 Z %80 \[ %81
	\\ %86 \] %87 ^ %84 _ %85 ` %BA a %BB b %B8 c %B9 d %BE e %BF
	f %BC g %BD h %B2 i %B3 j %B0 k %B1 l %B6 m %B7 n %B4 o %B5
	p %AA q %AB r %A8 s %A9 t %AE u %AF v %AC w %AD x %A2 y %A3
	z %A0 \{ %A1 | %A6 \} %A7 ~ %A4 \177 %A5  Z  \[  X  Y  ^
	 _  \\  \]  R  S  P  Q  V  W  T
	 U  J  K  H  I  N  O  L  M  B
	 C  %40  A  F  G  D  E  z  \{  x
	 y  ~  %7F  |  \}  r  s  p  q  v
	 w  t  u  j  k  h  i  n  o  l
	 m  b  c  `  a  f ? g  d  e  %1A
	 %1B  %18  %19  %1E  %1F  %1C  %1D  %12  %13  %10
	 %11  %16  %17  %14  %15  %0A  %0B  %08  %09  %0E
	 %0F  %0C  %0D  %02  %03 ? %01  %06  %07  %04
	 %05  %3A  ;  8  9  >  %3F  <  =  2
	 3  0  1  6  7  4  5  *  +  (
	 )  .  /  ,  -  \"  #  " "  !  &
	 '  \$  %25
}

# Save current window and uploads it to the ftp server.
proc html::SavetoFTPServer {} {
	global html::Passwords html::CurrentUpload html::mkdir html::ftpMultiple html::dirtomake html::originaldirtomake

	set win [html::StrippedFrontWindowPath]
	if {[set this [html::ThisFilePath 4]] == ""} {return}
	set home [lindex $this 3]
	if {$home == "" && [lindex $this 0] != "file:///"} {set home [html::InWhichHomePage "[lindex $this 0][lindex $this 1]"]}
	if {$home == "" || [lindex $this 4] == "4"} {
		alertnote "Current window is not in a home page folder."
		return
	}
	
	if {[set serv [html::GetServerAndPassword $home]] == ""} {return}
	save
	set html::ftpMultiple 0
	set path [lindex $this 2]
	if {[lindex $serv 4] != ""} {set path [join [list [lindex $serv 4] $path] /]}
	set html::originaldirtomake [set html::dirtomake [string range $path 0 [string last / $path]]]
	set html::mkdir [list [lindex $serv 1] ${html::dirtomake} [lindex $serv 2] [set html::Passwords($home)]]
	eval [set html::CurrentUpload [list ftpStore $win [lindex $serv 1] $path [lindex $serv 2] [set html::Passwords($home)] html::HandleReply]]
}

proc html::GetServerAndPassword {home} {
	global html::Passwords HTMLmodeVars
	
	foreach f $HTMLmodeVars(FTPservers) {
		if {[lindex $f 0] == $home} {set serv $f}
	}
	if {![info exists serv]} {
		alertnote "No ftp server specified for this home page."
		html::HomePages "[lindex $this 0][lindex $this 1]"
		return
	}
	
	if {[lindex $serv 3] != ""} {set html::Passwords($home) [lindex $serv 3]}
	if {![info exists html::Passwords($home)]} {
		if {![catch {dialog::password "Password for [lindex $serv 1]:"} pword]} {
			set html::Passwords($home) $pword
		} else {
			return
		}
	}
	return $serv
}

proc html::HandleReply {reply} {
	global html::Passwords html::mkdir html::ftpMultiple
	regsub {\\\{} $reply "{" reply
	regsub {\\\}} $reply "}" reply
	set ans [string range $reply 10 end]
	if {[regexp {^errs:([^]+)} $ans dum err]} {
		# Fetch error
		if {[regexp {Error: (.*)} $err dum err2]} {set err $err2}
		if {$err == "that file or directory is unavailable or non-existent."} {
			message "Creating new directory on server."
			eval html::ftpMkDir ${html::mkdir}
		} else {
			switchTo 'ALFA'
			alertnote "Ftp error: $err"
			unset html::Passwords
		}
	} elseif {[regexp {^'----':-?([0-9]*)} $ans dum err]} {
		if {$err != "0"} {
			# Anarchie error.
			if {$err == "553" || $err == "550"} {
				message "Creating new directory on server."
				eval html::ftpMkDir ${html::mkdir}
			} else {
				switchTo 'ALFA'
				alertnote "Ftp error: $err"
				unset html::Passwords
			}
		} else {
			message "Document uploaded to ftp server."
			if {${html::ftpMultiple}} {html::UploadNextFile}
		}
	} elseif {$ans == "\}"} {
		message "Document uploaded to ftp server."
		if {${html::ftpMultiple}} {html::UploadNextFile}
	} else {
		return 0
	}
	return 1
}

proc html::ftpMkDir {host path user password} {
	global ftpSig 
	switch $ftpSig {
		Arch -
		FTCh {
			currentReplyHandler html::MkDirHandler
			AEBuild -q -t 30000 '$ftpSig' Arch MkDr FTPh "$host" FTPc "$path" ArGU "$user" ArGp "$password"
		}
		Woof {
			global ALPHA html::TmpFolder
			set dirpath [string range $path 0 [expr {[string last / [string trimright $path /]] - 1}]]
			file::ensureDirExists ${html::TmpFolder}
			set fid [open [file join ${html::TmpFolder} Woof] "w"]
			puts $fid "auto result;"
			puts $fid "auto script;"
			puts $fid "auto ftpRef = NFCreateFTPInstance();"
			puts $fid "NFLoadModuleConstants();"
			puts $fid "do \{"
			puts $fid "if (result = NFConnect(ftpRef, \"$host\", 21, \"$user\", \"$password\"), result != 0) break;"
			puts $fid "if (result = NFChangeWorkingDirectory(ftpRef, \"$dirpath\"), result != 0) break;"
			puts $fid "if (result = NFMakeDirectory(ftpRef, \"$path\"), result != 0) break;"
			puts $fid "\} while(0);"
			puts $fid "NFDisconnect(ftpRef);"
			puts $fid "NFDeleteFTPInstance(ftpRef);"
			puts $fid "script = \"tell app \\\"$ALPHA\\\"\\r ignoring application responses \\r DoScript \\\"html::MkDirHandler aevt\\\\\\\\\\\\\\\\ansr\\\\\\\\\\\\\\\\{'----':\" + string(result) + \"\\\\\\\\\\\\\\\\}\\\"\\r end ignoring\\r end tell\";"
			puts $fid "MICI.ExecuteScript(script);"
			close $fid
			setFileInfo [file join ${html::TmpFolder} Woof] type ICI!
			sendOpenEvent noReply 'Woof' [file join ${html::TmpFolder} Woof]
		}
	}
}

proc html::MkDirHandler {reply} {
	global html::CurrentUpload html::mkdir html::dirtomake html::originaldirtomake
	regsub {\\\{} $reply "{" reply
	regsub {\\\}} $reply "}" reply
	set ans [string range $reply 10 end]
	if {[regexp {^errs:([^]+)} $ans dum err]} {
		# Fetch error
		if {[regexp {Error: (.*)} $err dum err2]} {set err $err2}
		if {$err == "that file or directory is unavailable or non-existent."} {
			set html::dirtomake [string range ${html::dirtomake} 0 [string last / [string trimright ${html::dirtomake} /]]] 
			eval html::ftpMkDir [lreplace ${html::mkdir} 1 1 ${html::dirtomake}]
		} else {
			switchTo 'ALFA'
			alertnote "Ftp error: $err"
		}
	} elseif {[regexp {^'----':-?([0-9]*)} $ans dum err]} {
		if {$err != "0"} {
			# Anarchie error
			if {$err == "553" || $err == "550" || $err == "521"} {
				set html::dirtomake [string range ${html::dirtomake} 0 [string last / [string trimright ${html::dirtomake} /]]] 
				eval html::ftpMkDir [lreplace ${html::mkdir} 1 1 ${html::dirtomake}]
			} else {
				switchTo 'ALFA'
				alertnote "Ftp error: $err"
			}
		} else {
			message "Directory created on server."
			set html::dirtomake ${html::originaldirtomake}
			eval ${html::CurrentUpload}
		}
	} elseif {$ans == "\}"} {
		set html::dirtomake ${html::originaldirtomake}
		message "Directory created on server."
		eval ${html::CurrentUpload}
	} else {
		return 0
	}
	return 1
}

proc html::ForgetPasswords {} {
	global html::Passwords
	message "Passwords forgotten."
	unset html::Passwords
}

proc html::UploadHomePage {} {
	global html::fid html::baselen html::serv html::ftpMultiple html::home ftpSig ftpSigs 
	global HTMLmodeVars html::Passwords html::limit tcl_precision
	if {![html::IsThereAHomePage] || [catch {html::WhichHomePage "upload files from"} hp]} {return}
	set html::home [lindex $hp 0]
	if {[set html::serv [html::GetServerAndPassword ${html::home}]] == ""} {return}
	app::launchAnyOfThese $ftpSigs ftpSig "Please locate your ftp application:"
	if {$ftpSig == "Arch"} {
		if {$HTMLmodeVars(anarchieMirrorWarn)} {
			set val [dialog -w 400 -h 110 -t "Warning! Files on your server not found on your disk will be deleted from the server." 10 10 390 40 \
			  -c "Don't warn me about this in the future." 0 10 50 390 65 \
			  -b OK 320 80 385 100 -b Cancel 235 80 300 100]
			if {[lindex $val 0]} {
				set HTMLmodeVars(anarchieMirrorWarn) 0
				prefs::modifiedModeVar anarchieMirrorWarn HTML
			}
			if {[lindex $val 2]} {return}
		}
		
		AEBuild '$ftpSig' Arch MPut ---- "${html::home}" FTPh "[lindex ${html::serv} 1]" FTPc "[lindex ${html::serv} 4]" ArGU "[lindex ${html::serv} 2]" ArGp "[set html::Passwords(${html::home})]"
		return
	}
	if {$ftpSig == "Woof"} {
		html::NetFinderMirror ${html::serv}
		return
	}
	set val [dialog -w 330 -h 100 -t "Upload files modified within the last" 10 10 290 30 -e "" 15 40 45 55 \
	  -m {hours days hours minutes} 60 40 200 60 -b OK 250 70 315 90 -b Cancel 165 70 230 90 -b "Upload all files" 10 70 130 90]
	set age [string trim [lindex $val 0]]
	if {[lindex $val 3] || (![is::PositiveInteger $age] && ![lindex $val 4])} {return}
	if {[lindex $val 4]} {
		set html::limit 0
	} else {
		if {![info exists tcl_precision]} {
			set old_precision 6
		} else {
			set old_precision $tcl_precision
		} 
		set tcl_precision 17
		switch [lindex $val 1] {
			days {set html::limit [expr [now].0 - $age * 86400]}
			hours {set html::limit [expr [now].0 - $age * 3600]}
			minutes {set html::limit [expr [now].0 - $age * 60]}
		}
		set tcl_precision $old_precision
		regexp {[^\.]+} ${html::limit} html::limit
	}
	message "Building file list"
	set filelist [html::OpenAfile]
	set html::fid [lindex $filelist 0]
	set folders [list ${html::home}]
	while {[llength $folders]} {
		set newFolders ""
		foreach fl $folders { 
			foreach f [glob -nocomplain -dir $fl *] {
				if {[file isdirectory $f]} {
					lappend newFolders $f
				} else {
					puts ${html::fid} $f
				}
			}
		}
		set folders $newFolders
	}
	seek ${html::fid} 0
	set html::baselen [expr {[string length ${html::home}] + 1}]
	set html::ftpMultiple 1
	html::UploadNextFile	
}

proc html::UploadNextFile {} {
	global html::fid html::baselen html::Passwords file::separator html::serv html::home html::mkdir html::CurrentUpload html::dirtomake useTclServiceForFtp
	while {![eof ${html::fid}] && [set f1 [gets ${html::fid} f]] != -1 && ![html::ModifiedRecently $f]} {}
	if {$f1 != -1} {
		set path [string range $f ${html::baselen} end]
		regsub -all ${file::separator} $path {/} path
		if {[lindex ${html::serv} 4] != ""} {set path [join [list [lindex ${html::serv} 4] $path] /]}
		set html::dirtomake [string range $path 0 [string last / $path]]
		set html::mkdir [list [lindex ${html::serv} 1] ${html::dirtomake} [lindex ${html::serv} 2] [set html::Passwords(${html::home})]]
		eval [set html::CurrentUpload [list ftpStore $f [lindex ${html::serv} 1] $path [lindex ${html::serv} 2] [set html::Passwords(${html::home})] html::HandleReply]]
		if {[info exists useTclServiceForFtp] && $useTclServiceForFtp} {
			html::UploadNextFile
		}
	} else {
		close ${html::fid}
		message "All documents uploaded to ftp server."
	}
}

proc html::ModifiedRecently {f} {
	global html::limit
	getFileInfo $f arr
	return [expr {${html::limit} == 0 || ${html::limit} < $arr(modified)}]
}

proc html::NetFinderMirror {server} {
	global html::NFpwList PREFS html::NFmirrorFiles html::TmpFolder
	if {![info exists html::NFmirrorFiles([lindex $server 0])] || 
	([set html::NFmirrorFiles([lindex $server 0])] != ":Generic" && ![file exists [set html::NFmirrorFiles([lindex $server 0])]])} {
		set val [dialog -w 400 -h 100 -t "No NetFinder mirror file has been selected for this home page. Either select one or let Alpha use a generic one.\
		  If you select one it may only contain one single mirror item." 10 10 390 60 \
		  -b Select 320 70 385 90 -b "Use generic" 100 70 190 90 -b Cancel 235 70 300 90]
		if {[lindex $val 2]} {return}
		if {[lindex $val 0]} {
			html::PickNFmirrorFile [lindex $server 0]
		} else {
			set html::NFmirrorFiles([lindex $server 0]) ":Generic"
			prefs::modifiedArrayElement [lindex $server 0] html::NFmirrorFiles
		}
	}
	if {[set html::NFmirrorFiles([lindex $server 0])] == ":Generic"} {
		file::ensureDirExists ${html::TmpFolder}
		set i 0
		while {[file exists [file join ${html::TmpFolder} NFmirror$i]]} {incr i}
		set fil [file join ${html::TmpFolder} NFmirror$i]
		set passw ""
		for {set i 0} {$i < [string length [lindex $server 3]]} {incr i} {
			append passw [set html::NFpwList([string index [lindex $server 3] $i])]
		}
		set path [makeAlis "[lindex $server 0]:"]
		regexp {(.*)} $path "" path
		set out "<NFML>\n\n<head>\n\t<version=1.0>\n\t<encoding=Macintosh>\n</head>\n\n<body>\n\n<item>\n\t<attributes>\n\t\t<name=\"HTML mode mirror\">"
		append out "\n\t\t<type=MIRROR_ITEM>\n\t\t<source>\n\t\t\t<alias="
		for {set i 0} {$i < [string length $path]} {incr i 64} {
			append out "\n[string range $path $i [expr {$i + 63}]]"
		}
		append out ">\n\t\t\t<path=\"[lindex $server 0]:\">\n\t\t</source>\n\t\t<target>"
		append out "\n\t\t\t<url=ftp://[lindex $server 2]:${passw}@[lindex $server 1]/[lindex $server 4]>"
		append out "\n\t\t</target>\n\t\t<mirror_options=by_name,by_size>\n\t\t<comment=\"\">"
		append out "\n\t\t<label=0>\n\t\t<lock_status=UNLOCKED>\n\t\t<stationery_status=NORMAL>\n\t</attributes>\n</item>\n\n</body>\n</NFML>"
		set fid [open $fil w]
		puts $fid $out
		close $fid
		setFileInfo $fil type Mirr
	} else {
		set fil [set html::NFmirrorFiles([lindex $server 0])]
		html::CheckNFmirrorFile $fil [lindex $server 0]
	}
	sendOpenEvent -r 'Woof' $fil
	switchTo 'Woof'
	# A little delay to make sure window is opened
	set t [ticks]
	while {[expr {[ticks] - $t < 30}]} {}
	AEBuild 'Woof' NFAE SAll
	AEBuild 'Woof' NFAE OPEN
}

proc html::NetFinderMirrorFiles {} {
	global html::NFmirrorFiles
	if {![html::IsThereAHomePage] || [catch {html::WhichHomePage "pick a NetFinder file for"} hp]} {return}
	if {![info exists html::NFmirrorFiles([lindex $hp 0])]} {
		set current "None"
	} else {
		set current [dialog::specialView::file [string trimleft [set html::NFmirrorFiles([lindex $hp 0])] :]]
	}
	while {1} {
		set box ""
		if {[info tclversion] >= 8.0} {set box "-T {NetFinder Mirror File}"}
		lappend box -t "NetFinder mirror file for\r[lindex $hp 1][lindex $hp 2]" 10 10 390 40 \
	  -t "Current file: $current" 10 50 390 65 \
	  -t "You can either select a NetFinder mirror file for this home page folder or let Alpha use a generic one.\
	  If you select one it may only contain one single mirror item." 10 75 390 135 \
		  -b Select 320 140 385 160 -b "Use generic" 100 140 190 160 -b Cancel 235 140 300 160
		set val [eval [concat dialog -w 400 -h 170 $box]]
	if {[lindex $val 2]} {return}
	if {[lindex $val 0]} {
			if {![catch {html::PickNFmirrorFile [lindex $hp 0]}]} {
				message "\"[file tail [set html::NFmirrorFiles([lindex $hp 0])]]\" used for [lindex $hp 1][lindex $hp 2]."
				break
			}
	} else {
		set html::NFmirrorFiles([lindex $hp 0]) ":Generic"
		prefs::modifiedArrayElement [lindex $hp 0] html::NFmirrorFiles
			message "Generic NetFinder file used for [lindex $hp 1][lindex $hp 2]."
			break
		}		
	}
}

proc html::PickNFmirrorFile {folder} {
	global html::NFmirrorFiles
	set fil [getfile "NetFinder mirror file"]
	html::CheckNFmirrorFile $fil $folder
	set html::NFmirrorFiles($folder) $fil
	prefs::modifiedArrayElement $folder html::NFmirrorFiles
}

proc html::CheckNFmirrorFile {fil folder} {
	if {[getFileType $fil] == "Mirr"} {
		set fcont [file::readAll $fil]
		if {[regsub -all {<item>} $fcont "" ""] != 1} {
			alertnote "The mirror file '[file tail $fil]' must contain one single item."
			error ""
		}
		if {![regexp "<path=\"$folder:\">" $fcont]} {
			alertnote "The file '[file tail $fil]' is not a mirror file for the folder '[file tail $folder]'."
			error ""
		}
	} else {
		alertnote "'[file tail $fil]' is not a NetFinder mirror file."
		error ""
	}
}
